<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    protected $table = 'ventas';
    protected $primaryKey = 'ID_VENTA';

    protected $fillable = [
        'FECHA_REGISTRO',
        'ID_PRODUCTO',
        'CANTIDAD',
        'MONTO_PRODUCTO',
        'DESCUENTO_PRODUCTO',
        'METODO_PAGO',
        'TOTAL_VENTA',
        'ID_EMPLEADO'
    ];

    public function producto()
    {
        return $this->belongsTo(Producto::class, 'ID_PRODUCTO', 'ID_PRODUCTO');
    }

    public function empleado()
    {
        return $this->belongsTo(Empleado::class, 'ID_EMPLEADO', 'ID_EMPLEADO');
    }
}
