<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('empleados', function (Blueprint $table) {
            $table->string('ID_EMPLEADO')->primary();

            $table->string('NOMBRE_EMPLEADO');
            $table->string('APELLIDO_EMPLEADO');

            // DNI: en BD suele ser mejor string (puede iniciar con 0 y no se calcula)
            $table->string('DNI_EMPLEADO', 8)->unique();

            $table->unsignedTinyInteger('EDAD_EMPLEADO')->nullable();
            $table->string('TELEFONO_EMPLEADO', 9)->nullable();

            $table->enum('ESTADO_EMPLEADO', ['ACTIVO', 'INACTIVO'])->default('ACTIVO');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('empleados');
    }
};
