<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usuarios', function (Blueprint $table) {
            $table->string('ID_USUARIO')->primary();

            $table->string('ID_EMPLEADO');
            $table->string('CONTRASENA');
            $table->string('ROL'); // ADMIN / CAJERO / MOZO ...
            $table->enum('ESTADO_USUARIO', ['ACTIVO', 'INACTIVO'])->default('ACTIVO');

            $table->timestamps();

            $table->foreign('ID_EMPLEADO')
                ->references('ID_EMPLEADO')
                ->on('empleados')
                ->onUpdate('cascade')
                ->onDelete('restrict'); // o cascade si quieres borrar usuario al borrar empleado
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usuarios');
    }
};
