<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ventas', function (Blueprint $table) {
            $table->id('ID_VENTA');

            $table->dateTime('FECHA_REGISTRO');

            $table->string('ID_PRODUCTO', 20);
            $table->integer('CANTIDAD');

            $table->decimal('MONTO_PRODUCTO', 10, 2);
            $table->decimal('DESCUENTO_PRODUCTO', 10, 2)->default(0);

            $table->enum('METODO_PAGO', ['EFECTIVO', 'YAPE_PLIN', 'TARJETA']);

            $table->decimal('TOTAL_VENTA', 10, 2);

            $table->string('ID_EMPLEADO', 20);

            $table->timestamps();

            $table->foreign('ID_PRODUCTO')->references('ID_PRODUCTO')->on('productos');
            $table->foreign('ID_EMPLEADO')->references('ID_EMPLEADO')->on('empleados');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ventas');
    }
};
