<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reporte_ventas', function (Blueprint $table) {
            $table->id('ID_REPORTE');

            $table->dateTime('FECHA_REPORTE');

            $table->decimal('EFECTIVO_REPORTE', 10, 2)->default(0);
            $table->decimal('YAPE_PLIN_REPORTE', 10, 2)->default(0);
            $table->decimal('TARJETA_REPORTE', 10, 2)->default(0);

            $table->decimal('TOTAL_DESCUENTOS', 10, 2)->default(0);
            $table->decimal('TOTAL_REPORTE', 10, 2);

            $table->string('ID_EMPLEADO', 20);

            $table->timestamps();

            $table->foreign('ID_EMPLEADO')->references('ID_EMPLEADO')->on('empleados');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reporte_ventas');
    }
};
