<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('apertura_cajas', function (Blueprint $table) {
            $table->id('ID_APERTURA');

            $table->dateTime('FECHA_APERTURA');
            $table->decimal('MONTO_APERTURA', 10, 2);

            $table->string('ID_EMPLEADO', 20);

            $table->timestamps();

            $table->foreign('ID_EMPLEADO')->references('ID_EMPLEADO')->on('empleados');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('apertura_cajas');
    }
};
