<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cierre_cajas', function (Blueprint $table) {
            $table->id('ID_CIERRE');

            $table->dateTime('FECHA_CIERRE_CAJA');

            $table->unsignedBigInteger('ID_APERTURA');
            $table->unsignedBigInteger('ID_REPORTE');

            $table->decimal('MONTO_APERTURA', 10, 2);
            $table->decimal('EFECTIVO_VENTAS', 10, 2);
            $table->decimal('EFECTIVO_SISTEMA', 10, 2);
            $table->decimal('EFECTIVO_FISICO', 10, 2);

            $table->decimal('DINERO_SOBRANTE', 10, 2)->default(0);
            $table->decimal('DINERO_FALTANTE', 10, 2)->default(0);

            $table->string('OBSERVACION_CIERRE', 255)->nullable();

            $table->enum('ESTADO_CIERRE', ['ABIERTO', 'CERRADO'])->default('CERRADO');

            $table->string('ID_EMPLEADO', 20);

            $table->timestamps();

            $table->foreign('ID_APERTURA')->references('ID_APERTURA')->on('apertura_cajas');
            $table->foreign('ID_REPORTE')->references('ID_REPORTE')->on('reporte_ventas');
            $table->foreign('ID_EMPLEADO')->references('ID_EMPLEADO')->on('empleados');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cierre_cajas');
    }
};
