<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ReporteVenta;
use Carbon\Carbon;

class ReporteVentaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [

            // ===== 2021 =====
            [2021, 1, 12, 320, 120, 180, 10],
            [2021, 6, 18, 450, 200, 300, 20],
            [2021, 12, 22, 520, 280, 350, 30],

            // ===== 2022 =====
            [2022, 1, 15, 350, 140, 210, 15],
            [2022, 6, 20, 480, 230, 320, 25],
            [2022, 12, 24, 560, 300, 400, 35],

            // ===== 2023 =====
            [2023, 1, 14, 380, 160, 240, 18],
            [2023, 6, 19, 520, 260, 360, 28],
            [2023, 12, 23, 610, 340, 450, 40],

            // ===== 2024 =====
            [2024, 1, 13, 420, 180, 280, 20],
            [2024, 6, 21, 560, 290, 400, 30],
            [2024, 12, 26, 680, 380, 520, 45],

            // ===== 2025 =====
            [2025, 1, 11, 460, 210, 320, 22],
            [2025, 6, 22, 600, 330, 460, 35],
            [2025, 12, 27, 720, 420, 580, 50],

            // ===== 2026 =====
            [2026, 1, 2,  420, 180, 250, 15],
            [2026, 1, 3,  365, 210, 150, 10],
            [2026, 1, 4,  500, 300, 200, 25],
        ];

        foreach ($data as $row) {

            [$anio, $mes, $dia, $ef, $yp, $tj, $desc] = $row;

            $totalGeneral = $ef + $yp + $tj;
            $totalReporte = max(0, $totalGeneral - $desc);

            ReporteVenta::updateOrCreate(
                [
                    'FECHA_REPORTE' => Carbon::create($anio, $mes, $dia, 23, 59, 59),
                ],
                [
                    'EFECTIVO_REPORTE'  => $ef,
                    'YAPE_PLIN_REPORTE' => $yp,
                    'TARJETA_REPORTE'   => $tj,
                    'TOTAL_DESCUENTOS'  => $desc,
                    'TOTAL_REPORTE'     => $totalReporte,
                    'ID_EMPLEADO'       => 'RUBY FALCON Q.',
                ]
            );
        }
    }
}
