<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Usuario;
use Illuminate\Support\Facades\Hash;

class UsuarioSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // ADMIN
        Usuario::updateOrCreate(
            ['ID_USUARIO' => 'RUBY FALCON Q.'],
            [
                'ID_EMPLEADO' => 'RUBY FALCON Q.',
                'CONTRASENA' => Hash::make('rubyfalcon'),
                'ROL' => 'ADMIN',
                'ESTADO_USUARIO' => 'ACTIVO',
            ]
        );

        // VENDEDOR 1
        Usuario::updateOrCreate(
            ['ID_USUARIO' => 'MARIA AVENDANO T.'],
            [
                'ID_EMPLEADO' => 'MARIA AVENDANO T.',
                'CONTRASENA' => Hash::make('mariaavendano'),
                'ROL' => 'VENDEDOR',
                'ESTADO_USUARIO' => 'ACTIVO',
            ]
        );

        // VENDEDOR 2
        Usuario::updateOrCreate(
            ['ID_USUARIO' => 'MAYERLI TICONA Q.'],
            [
                'ID_EMPLEADO' => 'MAYERLI TICONA Q.',
                'CONTRASENA' => Hash::make('mayerliticona'),
                'ROL' => 'VENDEDOR',
                'ESTADO_USUARIO' => 'ACTIVO',
            ]
        );
    }
}
