@extends('layouts.app')
@section('title', 'Abrir Caja')

@push('styles')
    @vite(['resources/css/apertura-create.css'])
@endpush

@section('content')
    <div class="ac-page">
        <div class="ac-card">

            {{-- HEADER / BANNER --}}
            <div class="ac-banner">
                <div class="ac-ico">🏦</div>

                <div class="ac-title">
                    <h1>Abrir Caja</h1>
                    <p>Registra el dinero inicial de caja del día.</p>

                    {{-- BADGE ÚNICO (evita repetir "Caja") --}}
                    @if (isset($aperturaHoy) && $aperturaHoy)
                        <span class="ac-badge success">Apertura registrada hoy ✅</span>
                    @else
                        <span class="ac-badge">Caja</span>
                    @endif
                </div>

                {{-- TAG solo desktop/tablet --}}
                <span class="ac-tag">Caja</span>
            </div>

            {{-- SI YA HAY APERTURA --}}
            @if (isset($aperturaHoy) && $aperturaHoy)
                <div class="ac-alert success">
                    <div class="ac-alert-ico">✅</div>
                    <div class="ac-alert-text">
                        <b>Ya existe una apertura registrada hoy.</b>
                        <div class="mini">
                            Monto: <b>S/ {{ number_format($aperturaHoy->MONTO_APERTURA, 2) }}</b> •
                            Hora: <b>{{ \Carbon\Carbon::parse($aperturaHoy->FECHA_APERTURA)->format('H:i') }}</b>
                        </div>
                        <div class="mini2">
                            Por seguridad, no se puede registrar otra apertura el mismo día.
                        </div>
                    </div>
                </div>

                <div class="ac-actions">
                    <a class="btn-pill primary" href="{{ route('apertura.index') }}">Ver aperturas</a>
                    <a class="btn-pill ghost" href="{{ route('dashboard') }}">Volver</a>
                </div>
            @else
                {{-- ERROR FLASH --}}
                @if (session('error'))
                    <div class="ac-alert danger">
                        <div class="ac-alert-ico">⚠️</div>
                        <div class="ac-alert-text">
                            <b>{{ session('error') }}</b>
                        </div>
                    </div>
                @endif

                {{-- FORM --}}
                <form method="POST" action="{{ route('apertura.store') }}" class="ac-form" autocomplete="off">
                    @csrf

                    <div class="field">
                        <label for="MONTO_APERTURA">Monto de apertura</label>

                        <div class="money">
                            <span class="money-prefix">S/</span>
                            <input id="MONTO_APERTURA" type="number" step="0.01" name="MONTO_APERTURA"
                                value="{{ old('MONTO_APERTURA') }}" placeholder="0.00" required inputmode="decimal"
                                autocomplete="off">
                        </div>

                        @error('MONTO_APERTURA')
                            <div class="err">{{ $message }}</div>
                        @enderror

                        <div class="hint">Ej: 200.00 (solo números)</div>
                    </div>

                    <div class="ac-actions">
                        <button class="btn-pill primary" type="submit">Guardar</button>
                        <a class="btn-pill ghost" href="{{ route('apertura.index') }}">Volver</a>
                    </div>
                </form>
            @endif
        </div>
    </div>
@endsection
