@extends('layouts.app')
@section('title', 'Aperturas de Caja')

@push('styles')
    @vite(['resources/css/apertura.css'])
@endpush

@section('content')
    @php($hoy = \App\Models\AperturaCaja::whereDate('FECHA_APERTURA', now())->first())

    <div class="page">
        <div class="page-head">
            <div>
                <h1>Aperturas de Caja</h1>
                <p class="sub">Control de apertura diaria para iniciar operaciones.</p>
            </div>

            @if ($hoy)
                <button class="btn-primary disabled" type="button" title="Ya existe una apertura hoy" disabled>
                    Apertura registrada hoy ✅
                </button>
            @else
                <a class="btn-primary" href="{{ route('apertura.create') }}">+ Nueva apertura</a>
            @endif
        </div>

        {{-- Estado de hoy --}}
        <div class="status-grid">
            <div class="status-card">
                <div class="st-top">
                    <span class="st-ico">🗓️</span>
                    <span class="st-tag">HOY</span>
                </div>

                @if ($hoy)
                    <h3 class="st-title ok">Caja abierta</h3>
                    <p class="st-text">Ya existe una apertura registrada para hoy.</p>

                    <div class="st-metrics">
                        <div class="metric">
                            <span class="k">Monto</span>
                            <span class="v">S/ {{ number_format($hoy->MONTO_APERTURA, 2) }}</span>
                        </div>
                        <div class="metric">
                            <span class="k">Hora</span>
                            <span class="v">{{ \Carbon\Carbon::parse($hoy->FECHA_APERTURA)->format('H:i') }}</span>
                        </div>
                    </div>
                @else
                    <h3 class="st-title warn">Apertura pendiente</h3>
                    <p class="st-text">Aún no se registró la apertura del día.</p>
                    <div class="st-metrics">
                        <div class="metric">
                            <span class="k">Acción</span>
                            <span class="v">Registrar apertura</span>
                        </div>
                    </div>
                @endif
            </div>

            <div class="status-card alt">
                <div class="st-top">
                    <span class="st-ico">🧠</span>
                    <span class="st-tag">TIP</span>
                </div>
                <h3 class="st-title">Buenas prácticas</h3>
                <p class="st-text">
                    Registra la apertura <b>una sola vez</b> al inicio del día.
                    Todos los turnos verán el estado y podrán continuar con ventas y cierre.
                </p>
            </div>
        </div>

        {{-- Tabla --}}
        <div class="table-card">
            <div class="table-head">
                <h2>Historial</h2>
                <span class="badge">{{ $aperturas->total() }} registros</span>
            </div>

            <div class="table-wrap">
                <table class="tul-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Fecha</th>
                            <th>Monto Apertura</th>
                            <th class="hide">ID Empleado</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($aperturas as $a)
                            <tr>
                                <td>#{{ $a->ID_APERTURA }}</td>
                                <td>{{ \Carbon\Carbon::parse($a->FECHA_APERTURA)->format('d/m/Y H:i') }}</td>
                                <td><b>S/ {{ number_format($a->MONTO_APERTURA, 2) }}</b></td>
                                <td class="hide">{{ $a->ID_EMPLEADO }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="empty">No hay aperturas registradas.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="pager">
                {{ $aperturas->links() }}
            </div>
        </div>
    </div>
@endsection
