<!doctype html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Login - Tulinda</title>

    {{-- Carga CSS separado con Vite --}}
    @vite(['resources/css/login.css'])
</head>

<body>

    <div class="bg"></div>

    <main class="wrap">
        <section class="card">

            {{-- LADO IZQUIERDO --}}
            <div class="left">
                <div class="brand">
                    <div class="brand__logo">
                        {{-- Pon tu logo en public/img/logo-tulinda.png --}}
                        <img src="{{ asset('img/logo-tulinda.png') }}" alt="Tulinda">
                    </div>

                    <div class="brand__text">
                        <h1>tulinda</h1>
                        <p>JOYERÍA ARTESANAL</p>
                    </div>
                </div>

                <h2 class="title">Accede a tu cuenta</h2>

                @if (session('error'))
                    <div class="alert alert--error">{{ session('error') }}</div>
                @endif

                <form class="form" method="POST" action="{{ route('login.do') }}" autocomplete="off">

                    @csrf

                    <!-- USUARIO -->
                    <div class="field floating has-icon">
                        <input name="ID_USUARIO" value="" placeholder=" " required autocomplete="off"
                            autocorrect="off" autocapitalize="off" spellcheck="false" inputmode="text">
                        <label>Usuario</label>

                        <span class="icon" aria-hidden="true">
                            {{-- icon user --}}
                            <svg viewBox="0 0 24 24" fill="none">
                                <path d="M12 12a4.5 4.5 0 1 0-4.5-4.5A4.5 4.5 0 0 0 12 12Z" stroke="currentColor"
                                    stroke-width="1.6" />
                                <path d="M4 20.2c1.8-3.9 5-6.2 8-6.2s6.2 2.3 8 6.2" stroke="currentColor"
                                    stroke-width="1.6" stroke-linecap="round" />
                            </svg>
                        </span>
                    </div>

                    <!-- CONTRASEÑA -->
                    <div class="field floating has-icon">
                        <input type="password" name="CONTRASENA" value="" placeholder=" " required
                            autocomplete="new-password" autocorrect="off" autocapitalize="off" spellcheck="false"
                            id="password">
                        <label>Contraseña</label>

                        <button type="button" class="icon-btn" aria-label="Mostrar u ocultar contraseña"
                            onclick="togglePassword()">
                            <!-- eye -->
                            <svg id="eye-open" viewBox="0 0 24 24" fill="none">
                                <path d="M1.5 12s4-7 10.5-7 10.5 7 10.5 7-4 7-10.5 7S1.5 12 1.5 12Z"
                                    stroke="currentColor" stroke-width="1.6" />
                                <circle cx="12" cy="12" r="3" stroke="currentColor" stroke-width="1.6" />
                            </svg>

                            <!-- eye off -->
                            <svg id="eye-closed" viewBox="0 0 24 24" fill="none" style="display:none">
                                <path d="M3 3l18 18" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                                <path d="M2 12s4-7 10-7c2 0 3.8.6 5.3 1.6M22 12s-4 7-10 7c-2.2 0-4.2-.7-5.8-1.9"
                                    stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                            </svg>
                        </button>
                    </div>

                    <button class="btn" type="submit">Ingresar</button>
                </form>


            </div>

            {{-- DIVISOR DIAGONAL --}}
            <div class="slash" aria-hidden="true"></div>

            {{-- LADO DERECHO --}}
            <div class="right">
                <div class="right__content">
                    <h3>Bienvenida a Tulinda</h3>
                    <p>Piezas hechas a mano para iluminar tus momentos.</p>

                    <div class="mock">
                        {{-- Pon tu collage en public/img/login-collage.png --}}
                        <img src="{{ asset('img/login-collage.png') }}" alt="Tulinda collage">
                    </div>
                </div>
            </div>

        </section>
    </main>

    <script>
        function togglePassword() {
            const input = document.getElementById('password');
            const eyeOpen = document.getElementById('eye-open');
            const eyeClosed = document.getElementById('eye-closed');

            if (input.type === 'password') {
                input.type = 'text';
                eyeOpen.style.display = 'none';
                eyeClosed.style.display = 'block';
            } else {
                input.type = 'password';
                eyeOpen.style.display = 'block';
                eyeClosed.style.display = 'none';
            }
        }
    </script>

</body>

</html>
