@extends('layouts.app')
@section('title', 'Nuevo Cierre')

@push('styles')
    @vite(['resources/css/cierre-create.css'])
@endpush

@section('content')
    <div class="ccc-page">
        <div class="ccc-card">
            <div class="ccc-head">
                <div class="ccc-ico">🔒</div>
                <div>
                    <h1>Cerrar Caja</h1>
                    <p>El sistema calcula cuánto debería haber en efectivo. Tú ingresas el conteo físico.</p>
                </div>
                <span class="ccc-tag">Caja</span>
            </div>

            <div class="resume">
                <div class="rline"><span>Apertura</span><b>S/ {{ number_format($montoApertura, 2) }}</b></div>
                <div class="rline"><span>Efectivo ventas</span><b>S/ {{ number_format($efectivo, 2) }}</b></div>
                <div class="rline total"><span>Efectivo sistema</span><b>S/ {{ number_format($efectivoSistema, 2) }}</b>
                </div>
            </div>

            <form method="POST" action="{{ route('cierre.store') }}" class="form">
                @csrf

                <div class="row">
                    <label>Conteo físico (S/)</label>
                    <input type="number" step="0.01" name="EFECTIVO_FISICO" required placeholder="Ej: 520.00">
                </div>

                <div class="actions">
                    <button class="btn-pill primary" type="submit">Registrar cierre</button>
                    <a class="btn-pill ghost" href="{{ route('cierre.index') }}">Volver</a>
                </div>
            </form>
        </div>
    </div>
    @push('scripts')
        <script>
            const sistema = {{ (float) $efectivoSistema }};
            const input = document.querySelector('input[name="EFECTIVO_FISICO"]');

            const box = document.createElement('div');
            box.style.marginTop = '10px';
            box.style.fontWeight = '900';
            box.style.color = '#7a5a66';
            input.parentElement.appendChild(box);

            function calc() {
                const v = parseFloat(input.value || '0');
                const diff = v - sistema;
                if (!input.value) {
                    box.textContent = '';
                    return;
                }
                if (diff === 0) box.textContent = '✅ Cierre correcto (0.00)';
                else if (diff > 0) box.textContent = '🟡 Sobra: S/ ' + diff.toFixed(2);
                else box.textContent = '🔴 Falta: S/ ' + Math.abs(diff).toFixed(2);
            }
            input.addEventListener('input', calc);
        </script>
    @endpush

@endsection
