@extends('layouts.app')
@section('title', 'Cierre de Caja')

@push('styles')
    @vite(['resources/css/cierre.css'])
@endpush

@section('content')
    <div class="cc-page">

        {{-- HERO HEADER --}}
        <div class="cc-hero">
            <div class="cc-hero-left">
                <div class="cc-title">
                    <span class="cc-dot"></span>
                    <div>
                        <h1>Cierres de Caja</h1>
                        <p class="sub">Resumen del día y registro final de caja.</p>
                    </div>
                </div>

                <div class="cc-mini">
                    <span class="mini-chip">Hoy: {{ now()->format('d/m/Y') }}</span>
                    @if ($cierreHoy)
                        <span class="mini-chip ok">Cierre registrado</span>
                    @else
                        <span class="mini-chip warn">Cierre pendiente</span>
                    @endif
                </div>
            </div>

            <div class="cc-hero-right">
                @if (!$cierreHoy)
                    <a class="btn-primary" href="{{ route('cierre.create') }}">+ Nuevo cierre</a>
                @else
                    <span class="btn-disabled">Cierre de hoy registrado</span>
                @endif
            </div>
        </div>

        {{-- STATS --}}
        <div class="cc-stats">
            <div class="stat s-apertura">
                <div class="stat-top">
                    <div class="ico">🗓️</div>
                    <div class="k">Apertura (hoy)</div>
                </div>
                <div class="v">S/ {{ number_format($montoApertura, 2) }}</div>
                <div class="t">{{ $aperturaHoy ? 'Registrada' : 'No registrada' }}</div>
            </div>

            <div class="stat s-efectivo">
                <div class="stat-top">
                    <div class="ico">💵</div>
                    <div class="k">Efectivo ventas</div>
                </div>
                <div class="v">S/ {{ number_format($efectivo, 2) }}</div>
                <div class="t">Ventas con EFECTIVO</div>
            </div>

            <div class="stat s-sistema">
                <div class="stat-top">
                    <div class="ico">🧮</div>
                    <div class="k">Efectivo sistema</div>
                </div>
                <div class="v">S/ {{ number_format($efectivoSistema, 2) }}</div>
                <div class="t">Apertura + Efectivo</div>
            </div>

            <div class="stat s-total">
                <div class="stat-top">
                    <div class="ico">📌</div>
                    <div class="k">Total ventas (hoy)</div>
                </div>
                <div class="v">S/ {{ number_format($totalHoy, 2) }}</div>
                <div class="t">Incluye yape/tarjeta</div>
            </div>
        </div>

        {{-- TABLA --}}
        <div class="table-card">
            <div class="table-head">
                <h2>Historial</h2>
                <span class="badge">{{ $cierres->total() }} registros</span>
            </div>

            <div class="table-wrap">
                <table class="tul-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Fecha</th>
                            <th>Sistema</th>
                            <th>Físico</th>
                            <th>Sobrante</th>
                            <th>Faltante</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($cierres as $c)
                            @php
                                $estado = 'CORRECTO';
                                if ($c->DINERO_SOBRANTE > 0) {
                                    $estado = 'SOBRA';
                                }
                                if ($c->DINERO_FALTANTE > 0) {
                                    $estado = 'FALTA';
                                }
                            @endphp
                            <tr>
                                <td>#{{ $c->ID_CIERRE }}</td>
                                <td>{{ \Carbon\Carbon::parse($c->FECHA_CIERRE_CAJA)->format('d/m/Y H:i') }}</td>
                                <td>S/ {{ number_format($c->EFECTIVO_SISTEMA, 2) }}</td>
                                <td>S/ {{ number_format($c->EFECTIVO_FISICO, 2) }}</td>
                                <td>S/ {{ number_format($c->DINERO_SOBRANTE, 2) }}</td>
                                <td>S/ {{ number_format($c->DINERO_FALTANTE, 2) }}</td>
                                <td>
                                    <span class="pill {{ strtolower($estado) }}">{{ $estado }}</span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="empty">No hay cierres registrados.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="pager">{{ $cierres->links() }}</div>
        </div>

    </div>
@endsection
