@extends('layouts.app')
@section('title', 'Dashboard')

@push('styles')
    @vite(['resources/css/dashboard.css'])
@endpush

@section('content')
    @php($u = session('usuario'))
    @php($rol = $u['ROL'] ?? 'INVITADO')
    @php($user = $u['ID_USUARIO'] ?? '')

    <div class="dash-wrap">

        {{-- HERO / HEADER --}}
        <section class="dash-hero">

            <div class="hero-left">
                <div class="brand">
                    <span class="brand-dot"></span>
                    <div class="brand-text">
                        <h1>Tulinda</h1>
                        <p>Panel de gestión • Caja & Ventas</p>
                    </div>
                </div>

                <div class="who">
                    <div class="who-row">
                        <span class="pill role">{{ $rol }}</span>
                        <span class="who-user">Bienvenido, <b>{{ $user }}</b></span>
                    </div>

                    {{-- ESTADOS DEL DÍA --}}
                    <div class="who-status">
                        @if (isset($aperturaHoy) && $aperturaHoy)
                            <span class="pill ok">Apertura registrada ✅</span>
                        @else
                            <span class="pill warn">Apertura pendiente</span>
                        @endif

                        @if (isset($cierreHoy) && $cierreHoy)
                            <span class="pill ok">Cierre registrado ✅</span>
                        @else
                            <span class="pill warn">Cierre pendiente</span>
                        @endif

                        @if (isset($reporteHoy) && $reporteHoy)
                            <span class="pill ok">Reporte generado ✅</span>
                        @else
                            <span class="pill warn">Reporte pendiente</span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="hero-actions">
                <a class="pill-btn" href="{{ route('ventas.create') }}">+ Nueva venta</a>

                {{-- ABRIR CAJA --}}
                @if (!isset($aperturaHoy) || !$aperturaHoy)
                    <a class="pill-btn" href="{{ route('apertura.create') }}">Abrir caja</a>
                @else
                    <button class="pill-btn disabled" type="button" disabled>Apertura ya registrada</button>
                @endif

                {{-- CERRAR CAJA --}}
                @if (isset($aperturaHoy) && $aperturaHoy && (!isset($cierreHoy) || !$cierreHoy))
                    <a class="pill-btn" href="{{ route('cierre.create') }}">Cerrar caja</a>
                @else
                    <button class="pill-btn disabled" type="button" disabled>
                        {{ isset($cierreHoy) && $cierreHoy ? 'Cierre ya registrado' : 'Primero apertura' }}
                    </button>
                @endif
            </div>
        </section>

        {{-- ✅ ANALÍTICA / COMPARATIVO (SOLO ADMIN) --}}
        @if ($rol === 'ADMIN')
            <section class="dash-analytics">
                <div class="analytics-card">

                    <div class="analytics-head">
                        <div class="analytics-title">
                            <h2>Analítica de ventas</h2>
                            <p>Compara años y visualiza la tendencia mensual (por tipo de pago).</p>
                        </div>

                        <button class="pill-btn" id="btnAplicarGrafico" type="button">Aplicar</button>
                    </div>

                    <div class="analytics-filters">
                        <div class="f-item">
                            <label>Año A</label>
                            <select id="anioA" class="f-select">
                                @foreach ($anios ?? [] as $a)
                                    <option value="{{ $a }}" @selected(isset($anioA) && $a == $anioA)>{{ $a }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="f-item">
                            <label>Año B</label>
                            <select id="anioB" class="f-select">
                                @foreach ($anios ?? [] as $a)
                                    <option value="{{ $a }}" @selected(isset($anioB) && $a == $anioB)>{{ $a }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        {{-- ✅ NUEVO: MÉTRICA (TIPO DE PAGO) --}}
                        <div class="f-item">
                            <label>Tipo / Métrica</label>
                            <select id="metric" class="f-select">
                                <option value="total" selected>Total ventas (S/)</option>
                                <option value="efectivo">Efectivo (S/)</option>
                                <option value="yape">Yape/Plin (S/)</option>
                                <option value="tarjeta">Tarjeta (S/)</option>
                                <option value="descuentos">Descuentos (S/)</option>
                            </select>
                            <small class="hint">Esto sale de <b>reporte_ventas</b> por mes.</small>
                        </div>

                        {{-- opcional: mantenemos el select de productos como catálogo (no filtra aún) --}}
                        <div class="f-item">
                            <label>Producto (catálogo)</label>
                            <select id="producto" class="f-select" disabled>
                                <option value="ALL">Todos los productos</option>
                                @foreach ($productos ?? [] as $p)
                                    <option value="{{ $p->ID_PRODUCTO }}">
                                        {{ $p->TIPO_PRODUCTO }} • S/ {{ number_format($p->PRECIO_PRODUCTO, 2) }} •
                                        ({{ $p->ID_PRODUCTO }})
                                    </option>
                                @endforeach
                            </select>
                            <small class="hint">Se habilita cuando tu sistema guarde detalle por producto.</small>
                        </div>
                    </div>

                    <div class="analytics-chart">
                        <canvas id="chartVentas" height="95"></canvas>
                    </div>

                </div>
            </section>
        @endif

        {{-- MÓDULOS --}}
        <section class="grid">
            <a class="card card-caja" href="{{ route('apertura.index') }}">
                <div class="card-top">
                    <div class="card-ico">🏦</div>
                    <span class="chip">Caja</span>
                </div>
                <h3>Apertura de caja</h3>
                <p>Registrar el monto inicial del día para habilitar el control de efectivo.</p>
                <div class="card-go">Ir al módulo <span>→</span></div>
            </a>

            <a class="card card-ventas" href="{{ route('ventas.index') }}">
                <div class="card-top">
                    <div class="card-ico">🧾</div>
                    <span class="chip">Ventas</span>
                </div>
                <h3>Ventas</h3>
                <p>Registrar ventas rápidas por método de pago y revisar lo vendido del día.</p>
                <div class="card-go">Ir al módulo <span>→</span></div>
            </a>

            <a class="card card-caja" href="{{ route('cierre.index') }}">
                <div class="card-top">
                    <div class="card-ico">🔒</div>
                    <span class="chip">Caja</span>
                </div>
                <h3>Cierre de caja</h3>
                <p>Comparar efectivo del sistema vs efectivo físico y registrar observación.</p>
                <div class="card-go">Ir al módulo <span>→</span></div>
            </a>

            <a class="card card-reporte" href="{{ route('reporte.index') }}">
                <div class="card-top">
                    <div class="card-ico">📊</div>
                    <span class="chip">Reporte</span>
                </div>
                <h3>Reportes</h3>
                <p>Generar y consultar reportes diarios (efectivo, tarjeta, yape/plin).</p>
                <div class="card-go">Ir al módulo <span>→</span></div>
            </a>

            @if ($rol === 'ADMIN')
                <a class="card card-maint" href="{{ route('empleados.index') }}">
                    <div class="card-top">
                        <div class="card-ico">👥</div>
                        <span class="chip">Mantenimiento</span>
                    </div>
                    <h3>Empleados</h3>
                    <p>Gestionar personal, datos y estado (activo/inactivo).</p>
                    <div class="card-go">Ir al módulo <span>→</span></div>
                </a>

                <a class="card card-maint" href="{{ route('productos.index') }}">
                    <div class="card-top">
                        <div class="card-ico">🍰</div>
                        <span class="chip">Mantenimiento</span>
                    </div>
                    <h3>Productos</h3>
                    <p>Configurar productos y precios para ventas rápidas.</p>
                    <div class="card-go">Ir al módulo <span>→</span></div>
                </a>

                <a class="card card-sec" href="{{ route('usuarios.index') }}">
                    <div class="card-top">
                        <div class="card-ico">🔑</div>
                        <span class="chip">Seguridad</span>
                    </div>
                    <h3>Usuarios</h3>
                    <p>Roles, accesos y estado de cuentas del sistema.</p>
                    <div class="card-go">Ir al módulo <span>→</span></div>
                </a>
            @endif
        </section>
    </div>

    {{-- Chart.js + JS de actualización (SOLO ADMIN) --}}
    @if ($rol === 'ADMIN')
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            let chartVentas;

            function moneyPE(value) {
                return new Intl.NumberFormat('es-PE', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                }).format(value);
            }

            function metricLabel(metric) {
                const map = {
                    total: 'Total ventas',
                    efectivo: 'Efectivo',
                    yape: 'Yape/Plin',
                    tarjeta: 'Tarjeta',
                    descuentos: 'Descuentos',
                };
                return map[metric] ?? 'Total ventas';
            }

            async function cargarGraficoVentas() {
                const anioA = document.getElementById('anioA')?.value;
                const anioB = document.getElementById('anioB')?.value;
                const metric = document.getElementById('metric')?.value ?? 'total';

                if (!anioA || !anioB) return;

                const url =
                    `{{ route('dashboard.data') }}?anioA=${encodeURIComponent(anioA)}&anioB=${encodeURIComponent(anioB)}&metric=${encodeURIComponent(metric)}`;

                const res = await fetch(url);
                if (!res.ok) return;

                const data = await res.json();

                const ctx = document.getElementById('chartVentas');
                if (!ctx) return;

                if (chartVentas) chartVentas.destroy();

                chartVentas = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels,
                        datasets: [{
                                label: `${anioA} • ${metricLabel(metric)}`,
                                data: data.serieA
                            },
                            {
                                label: `${anioB} • ${metricLabel(metric)}`,
                                data: data.serieB
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: (context) => {
                                        const v = context.raw ?? 0;
                                        return `${context.dataset.label}: S/ ${moneyPE(v)}`;
                                    }
                                }
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    callback: (value) => `S/ ${moneyPE(value)}`
                                }
                            }
                        }
                    }
                });
            }

            document.getElementById('btnAplicarGrafico')?.addEventListener('click', cargarGraficoVentas);

            // ✅ Opcional: que cambie al instante cuando cambias métrica o años
            document.getElementById('metric')?.addEventListener('change', cargarGraficoVentas);
            document.getElementById('anioA')?.addEventListener('change', cargarGraficoVentas);
            document.getElementById('anioB')?.addEventListener('change', cargarGraficoVentas);

            // carga inicial
            if (document.getElementById('anioA') && document.getElementById('anioB')) {
                cargarGraficoVentas();
            }
        </script>
    @endif
@endsection
