@extends('layouts.app')
@section('title', 'Registrar Empleado')

@push('styles')
    @vite(['resources/css/empleado-form.css'])
@endpush

@section('content')
    <div class="page">
        <div class="form-shell">
            <div class="form-head">
                <div>
                    <h1 class="title">Registrar Empleado</h1>
                    <p class="sub">Completa los datos del empleado para Tulinda.</p>
                </div>
                <div class="tag">Personal</div>
            </div>

            {{-- ALERTAS --}}
            @if (session('error'))
                <div class="alert err">{{ session('error') }}</div>
            @endif
            @if ($errors->any())
                <div class="alert err">
                    <ul style="margin:0; padding-left:18px;">
                        @foreach ($errors->all() as $e)
                            <li>{{ $e }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form method="POST" action="{{ route('empleados.store') }}" class="form-grid" id="empForm">
                @csrf

                <div class="field">
                    <label>ID Empleado</label>
                    <input type="text" name="ID_EMPLEADO" value="{{ old('ID_EMPLEADO') }}" placeholder="Ej: EMP004"
                        class="autoclear" data-autoclear="1" required>
                    <small>Formato sugerido: EMP###</small>
                </div>

                <div class="field">
                    <label>Estado</label>
                    <select name="ESTADO_EMPLEADO" required>
                        <option value="ACTIVO" {{ old('ESTADO_EMPLEADO', 'ACTIVO') === 'ACTIVO' ? 'selected' : '' }}>ACTIVO
                        </option>
                        <option value="INACTIVO" {{ old('ESTADO_EMPLEADO') === 'INACTIVO' ? 'selected' : '' }}>INACTIVO
                        </option>
                    </select>
                    <small>Controla si puede trabajar en el sistema.</small>
                </div>

                <div class="field">
                    <label>Nombres</label>
                    <input type="text" name="NOMBRE_EMPLEADO" value="{{ old('NOMBRE_EMPLEADO') }}"
                        placeholder="Ej: María" class="autoclear" data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>Apellidos</label>
                    <input type="text" name="APELLIDO_EMPLEADO" value="{{ old('APELLIDO_EMPLEADO') }}"
                        placeholder="Ej: Quispe" class="autoclear" data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>DNI</label>
                    <input type="text" name="DNI_EMPLEADO" value="{{ old('DNI_EMPLEADO') }}" placeholder="8 dígitos"
                        maxlength="8" inputmode="numeric" class="autoclear" data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>Teléfono</label>
                    <input type="text" name="TELEFONO_EMPLEADO" value="{{ old('TELEFONO_EMPLEADO') }}"
                        placeholder="Ej: 987654321" maxlength="9" inputmode="numeric" class="autoclear" data-autoclear="1"
                        required>
                </div>

                <div class="field">
                    <label>Edad</label>
                    <input type="number" name="EDAD_EMPLEADO" value="{{ old('EDAD_EMPLEADO') }}" placeholder="Ej: 28"
                        min="14" max="80" class="autoclear" data-autoclear="1" required>
                </div>

                <div class="actions">
                    <button class="btn primary" type="submit">Guardar</button>
                    <a class="btn" href="{{ route('empleados.index') }}">Volver</a>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Auto-borrar al enfocar, pero SOLO si el valor es exactamente el "old()" inicial
        // (así no te borra lo que ya escribiste si vuelves a hacer click)
        document.querySelectorAll('.autoclear[data-autoclear="1"]').forEach(el => {
            el.dataset.initial = el.value;

            el.addEventListener('focus', () => {
                if (el.value === el.dataset.initial) el.value = '';
            });

            el.addEventListener('blur', () => {
                // si lo dejas vacío y era requerido, volvemos a poner el inicial (por ejemplo 1 o 0 si lo usas)
                // aquí lo dejamos vacío para que el required haga su trabajo
            });
        });
    </script>
@endsection
