@extends('layouts.app')
@section('title', 'Editar Empleado')

@push('styles')
    @vite(['resources/css/empleado-form.css'])
@endpush

@section('content')
    <div class="page">
        <div class="form-shell">
            <div class="form-head">
                <div>
                    <h1 class="title">Editar Empleado</h1>
                    <p class="sub">Actualiza datos del personal en Tulinda.</p>
                    <p class="sub" style="margin-top:6px;">
                        <b>ID:</b> {{ $empleado->ID_EMPLEADO }}
                    </p>
                </div>
                <div class="tag">Personal</div>
            </div>

            {{-- ALERTAS --}}
            @if (session('error'))
                <div class="alert err">{{ session('error') }}</div>
            @endif
            @if ($errors->any())
                <div class="alert err">
                    <ul style="margin:0; padding-left:18px;">
                        @foreach ($errors->all() as $e)
                            <li>{{ $e }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form method="POST" action="{{ route('empleados.update', $empleado->ID_EMPLEADO) }}" class="form-grid"
                id="empEditForm">
                @csrf
                @method('PUT')

                <div class="field">
                    <label>Nombres</label>
                    <input type="text" name="NOMBRE_EMPLEADO"
                        value="{{ old('NOMBRE_EMPLEADO', $empleado->NOMBRE_EMPLEADO) }}" class="autoclear"
                        data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>Apellidos</label>
                    <input type="text" name="APELLIDO_EMPLEADO"
                        value="{{ old('APELLIDO_EMPLEADO', $empleado->APELLIDO_EMPLEADO) }}" class="autoclear"
                        data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>DNI</label>
                    <input type="text" name="DNI_EMPLEADO" value="{{ old('DNI_EMPLEADO', $empleado->DNI_EMPLEADO) }}"
                        maxlength="8" inputmode="numeric" class="autoclear" data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>Teléfono</label>
                    <input type="text" name="TELEFONO_EMPLEADO"
                        value="{{ old('TELEFONO_EMPLEADO', $empleado->TELEFONO_EMPLEADO) }}" maxlength="9"
                        inputmode="numeric" class="autoclear" data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>Edad</label>
                    <input type="number" name="EDAD_EMPLEADO" value="{{ old('EDAD_EMPLEADO', $empleado->EDAD_EMPLEADO) }}"
                        min="14" max="80" class="autoclear" data-autoclear="1" required>
                </div>

                <div class="field">
                    <label>Estado</label>
                    <select name="ESTADO_EMPLEADO" required>
                        @php($estado = old('ESTADO_EMPLEADO', $empleado->ESTADO_EMPLEADO))
                        <option value="ACTIVO" {{ $estado === 'ACTIVO' ? 'selected' : '' }}>ACTIVO</option>
                        <option value="INACTIVO" {{ $estado === 'INACTIVO' ? 'selected' : '' }}>INACTIVO</option>
                    </select>
                </div>

                <div class="actions">
                    <button class="btn primary" type="submit">Actualizar</button>
                    <a class="btn" href="{{ route('empleados.index') }}">Volver</a>
                </div>
            </form>
        </div>
    </div>

    <script>
        // En EDIT: borrar solo si NO has cambiado aún (valor igual al inicial)
        document.querySelectorAll('.autoclear[data-autoclear="1"]').forEach(el => {
            el.dataset.initial = el.value;

            el.addEventListener('focus', () => {
                if (el.value === el.dataset.initial) el.value = '';
            });

            // Si el usuario escribió algo, ya no vuelve a auto-borrar
            el.addEventListener('input', () => {
                if (el.value !== el.dataset.initial) el.dataset.locked = "1";
            });

            el.addEventListener('focus', () => {
                if (el.dataset.locked === "1") return;
                if (el.value === el.dataset.initial) el.value = '';
            });
        });
    </script>
@endsection
