@extends('layouts.app')
@section('title', 'Empleados')

@push('styles')
    @vite(['resources/css/empleados.css'])
@endpush

@section('content')
    <div class="page">
        <div class="page-head">
            <div class="head-left">
                <h1 class="page-title">Empleados</h1>
                <p class="page-sub">Gestión de personal de Tulinda: datos, estado y acciones rápidas.</p>
            </div>

            <div class="head-right">
                <a class="btn primary" href="{{ route('empleados.create') }}">+ Nuevo empleado</a>
            </div>
        </div>

        {{-- ALERTAS --}}
        @if (session('ok'))
            <div class="alert ok">{{ session('ok') }}</div>
        @endif
        @if (session('error'))
            <div class="alert err">{{ session('error') }}</div>
        @endif
        @if ($errors->any())
            <div class="alert err">
                <ul style="margin:0; padding-left:18px;">
                    @foreach ($errors->all() as $e)
                        <li>{{ $e }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="card">
            <div class="card-top">
                <div class="top-left">
                    <div class="pill">Listado</div>
                    <div class="muted">Total: <b>{{ $empleados->count() }}</b></div>
                </div>

                <div class="top-right">
                    <input id="empSearch" class="search" type="text"
                        placeholder="Buscar por nombre, apellido, DNI, teléfono...">
                </div>
            </div>

            <div class="table-wrap">
                <table class="tul-table" id="empTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nombres</th>
                            <th>Apellidos</th>
                            <th>DNI</th>
                            <th>Edad</th>
                            <th>Teléfono</th>
                            <th>Estado</th>
                            <th class="th-actions">Acciones</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($empleados as $e)
                            <tr>
                                <td class="mono">{{ $e->ID_EMPLEADO }}</td>
                                <td>{{ $e->NOMBRE_EMPLEADO }}</td>
                                <td>{{ $e->APELLIDO_EMPLEADO }}</td>
                                <td class="mono">{{ $e->DNI_EMPLEADO }}</td>
                                <td class="mono">{{ $e->EDAD_EMPLEADO }}</td>
                                <td class="mono">{{ $e->TELEFONO_EMPLEADO }}</td>
                                <td>
                                    @if (($e->ESTADO_EMPLEADO ?? '') === 'ACTIVO')
                                        <span class="badge success">ACTIVO</span>
                                    @else
                                        <span class="badge danger">INACTIVO</span>
                                    @endif
                                </td>
                                <td class="actions">
                                    <a class="btn sm" href="{{ route('empleados.edit', $e->ID_EMPLEADO) }}">Editar</a>

                                    <form method="POST" action="{{ route('empleados.destroy', $e->ID_EMPLEADO) }}"
                                        onsubmit="return confirm('¿Eliminar empleado {{ $e->ID_EMPLEADO }}?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn sm danger" type="submit">Eliminar</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="empty">No hay empleados registrados.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Si luego usas paginate(), aquí va:
            <div class="card-foot">
                {{ $empleados->links() }}
            </div>
            --}}
        </div>
    </div>

    <script>
        // Filtro rápido sin backend
        const input = document.getElementById('empSearch');
        const table = document.getElementById('empTable');
        const rows = () => Array.from(table.querySelectorAll('tbody tr'));

        input?.addEventListener('input', () => {
            const q = input.value.toLowerCase().trim();

            rows().forEach(r => {
                const txt = r.innerText.toLowerCase();
                // evita filtrar el row "No hay empleados"
                if (r.querySelector('.empty')) return;
                r.style.display = txt.includes(q) ? '' : 'none';
            });
        });
    </script>
@endsection
