@php
    $u = session('usuario', []);
    $rol = $u['ROL'] ?? '';
    $user = $u['ID_USUARIO'] ?? 'usuario';
    $initial = strtoupper(substr($user, 0, 1));

    // Activo para resaltar opción
    $isDash = request()->routeIs('dashboard');
    $isAper = request()->routeIs('apertura.*');
    $isVentas = request()->routeIs('ventas.*');
    $isCierre = request()->routeIs('cierre.*');
    $isReporte = request()->routeIs('reporte.*');
    $isUsers = request()->routeIs('usuarios.*');
@endphp

@vite(['resources/css/nav.css'])

<header class="tul-nav">
    <div class="nav-shell">

        {{-- ✅ Toggle mobile (debe ser hermano de .nav-mobile para que funcione el CSS) --}}
        <input type="checkbox" id="navToggle" class="nav-toggle" aria-label="Abrir menú">

        {{-- FILA 1 (marca + rol + burger) --}}
        <div class="nav-row nav-top">
            <a class="brand" href="{{ route('dashboard') }}">
                <span class="brand-dot"></span>
                <span class="brand-name">Tulinda</span>
            </a>

            <div class="nav-top-right">
                <span class="role-chip">{{ $rol }}</span>

                {{-- Botón hamburguesa --}}
                <label for="navToggle" class="nav-burger" aria-label="Menú">
                    <span></span><span></span><span></span>
                </label>
            </div>
        </div>

        {{-- FILA 2 (usuario + logout) --}}
        <div class="nav-row nav-bottom">
            <div class="user-pill">
                <div class="avatar">{{ $initial }}</div>
                <div class="uinfo">
                    <div class="uname">{{ $user }}</div>
                    <div class="urole">{{ $rol }}</div>
                </div>
            </div>

            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button class="logout-ghost" type="submit">Cerrar sesión</button>
            </form>
        </div>

        {{-- MENU DESKTOP (centrado) --}}
        <nav class="nav-desktop">
            <a class="{{ $isDash ? 'is-active' : '' }}" href="{{ route('dashboard') }}">Dashboard</a>
            <a class="{{ $isAper ? 'is-active' : '' }}" href="{{ route('apertura.index') }}">Apertura</a>
            <a class="{{ $isVentas ? 'is-active' : '' }}" href="{{ route('ventas.index') }}">Ventas</a>
            <a class="{{ $isCierre ? 'is-active' : '' }}" href="{{ route('cierre.index') }}">Cierre</a>

            @if (in_array($rol, ['ADMIN', 'VENDEDOR']))
                <a class="{{ $isReporte ? 'is-active' : '' }}" href="{{ route('reporte.index') }}">Reporte</a>
            @endif

            @if ($rol === 'ADMIN')
                <a class="{{ $isUsers ? 'is-active' : '' }}" href="{{ route('usuarios.index') }}">Usuarios</a>
            @endif
        </nav>

        {{-- MENU MOBILE (sheet) --}}
        <div class="nav-mobile">
            {{-- Backdrop para cerrar tocando afuera --}}
            <label for="navToggle" class="nav-backdrop" aria-hidden="true"></label>

            <div class="nav-sheet">
                <div class="sheet-head">
                    <div class="sheet-title">Menú</div>
                    <label for="navToggle" class="sheet-close" aria-label="Cerrar">✕</label>
                </div>

                <div class="sheet-links">
                    <a class="{{ $isDash ? 'is-active' : '' }}" href="{{ route('dashboard') }}">Dashboard</a>
                    <a class="{{ $isAper ? 'is-active' : '' }}" href="{{ route('apertura.index') }}">Apertura</a>
                    <a class="{{ $isVentas ? 'is-active' : '' }}" href="{{ route('ventas.index') }}">Ventas</a>
                    <a class="{{ $isCierre ? 'is-active' : '' }}" href="{{ route('cierre.index') }}">Cierre</a>

                    @if (in_array($rol, ['ADMIN', 'VENDEDOR']))
                        <a class="{{ $isReporte ? 'is-active' : '' }}" href="{{ route('reporte.index') }}">Reporte</a>
                    @endif

                    @if ($rol === 'ADMIN')
                        <a class="{{ $isUsers ? 'is-active' : '' }}" href="{{ route('usuarios.index') }}">Usuarios</a>
                    @endif
                </div>

                <div class="sheet-footer">
                    <div class="mini-user">
                        <span class="mini-ava">{{ $initial }}</span>
                        <div class="mini-txt">
                            <div class="mini-name">{{ $user }}</div>
                            <div class="mini-role">{{ $rol }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</header>
