@extends('layouts.app')
@section('title', 'Nuevo Producto')

@push('styles')
    @vite(['resources/css/tables.css'])
@endpush

@section('content')
    <div class="form-card">
        <h1>Registrar Producto</h1>

        <form method="POST" action="{{ route('productos.store') }}">
            @csrf

            <div class="form-row">
                <label>ID Producto</label>
                <input name="ID_PRODUCTO" value="{{ old('ID_PRODUCTO') }}" required>
            </div>

            <div class="form-row">
                <label>Tipo</label>
                <select name="TIPO_PRODUCTO" required>
                    <option value="PLATO">PLATO</option>
                    <option value="POSTRE">POSTRE</option>
                    <option value="BEBIDA">BEBIDA</option>
                </select>
            </div>

            <div class="form-row">
                <label>Precio</label>
                <input type="number" step="0.01" name="PRECIO_PRODUCTO" value="{{ old('PRECIO_PRODUCTO') }}" required>
            </div>

            <div class="form-row">
                <label>Estado</label>
                <select name="ESTADO_PRODUCTO" required>
                    <option value="ACTIVO" selected>ACTIVO</option>
                    <option value="INACTIVO">INACTIVO</option>
                </select>
            </div>

            <div class="form-actions">
                <button class="btn-sm primary" type="submit">Guardar</button>
                <a class="btn-sm" href="{{ route('productos.index') }}">Volver</a>
            </div>
        </form>
    </div>
@endsection
