@extends('layouts.app')
@section('title', 'Editar Producto')

@push('styles')
    @vite(['resources/css/productos-form.css'])
@endpush

@section('content')
    <div class="pf-page">

        <div class="pf-card">
            <div class="pf-head">
                <div>
                    <h1>Editar Producto</h1>
                    <p class="pf-muted">ID: <b>{{ $producto->ID_PRODUCTO }}</b></p>
                </div>

                <a class="pf-back" href="{{ route('productos.index') }}">← Volver</a>
            </div>

            <form class="pf-form" method="POST" action="{{ route('productos.update', $producto->ID_PRODUCTO) }}">
                @csrf
                @method('PUT')

                <div class="pf-grid">
                    <div class="pf-field">
                        <label>Tipo</label>
                        <select name="TIPO_PRODUCTO" required>
                            <option value="ARETES" @selected($producto->TIPO_PRODUCTO === 'ARETES')>ARETES</option>
                            <option value="COLLARES" @selected($producto->TIPO_PRODUCTO === 'COLLARES')>COLLARES</option>
                            <option value="PULSERAS" @selected($producto->TIPO_PRODUCTO === 'PULSERAS')>PULSERAS</option>
                            <option value="ANILLOS" @selected($producto->TIPO_PRODUCTO === 'ANILLOS')>ANILLOS</option>
                            <option value="OTROS" @selected($producto->TIPO_PRODUCTO === 'OTROS')>OTROS</option>
                        </select>

                    </div>

                    <div class="pf-field">
                        <label>Precio</label>
                        <input type="number" step="0.01" name="PRECIO_PRODUCTO"
                            value="{{ old('PRECIO_PRODUCTO', $producto->PRECIO_PRODUCTO) }}" required>
                    </div>

                    <div class="pf-field">
                        <label>Estado</label>
                        <select name="ESTADO_PRODUCTO" required>
                            <option value="ACTIVO" @selected($producto->ESTADO_PRODUCTO === 'ACTIVO')>ACTIVO</option>
                            <option value="INACTIVO" @selected($producto->ESTADO_PRODUCTO === 'INACTIVO')>INACTIVO</option>
                        </select>
                    </div>
                </div>

                <div class="pf-actions">
                    <button class="pf-btn pf-primary" type="submit">Actualizar</button>
                    <a class="pf-btn" href="{{ route('productos.index') }}">Cancelar</a>
                </div>
            </form>
        </div>

    </div>
@endsection
