@extends('layouts.app')
@section('title', 'Productos')

@push('styles')
    @vite(['resources/css/tables.css', 'resources/css/productos.css'])
@endpush

@section('content')
    <div class="prod-page">

        <div class="prod-shell">

            {{-- Header --}}
            <div class="prod-header">
                <div>
                    <h1 class="prod-title">Productos</h1>
                    <p class="prod-sub">Selecciona el tipo para encontrar rápido los ítems.</p>
                </div>

                <div class="prod-headerActions">
                    <a class="btn-sm primary" href="{{ route('productos.create') }}">
                        <span class="i">＋</span> Nuevo producto
                    </a>
                </div>
            </div>

            {{-- Toolbar simple: SOLO TIPO --}}
            <form class="prod-toolbar" method="GET" action="{{ route('productos.index') }}">
                <div class="prod-left">
                    <label class="prod-label">Tipo</label>

                    <select name="tipo" class="prod-select">
                        <option value="">Todos</option>
                        @foreach ($tipos as $t)
                            <option value="{{ $t }}" {{ request('tipo') == $t ? 'selected' : '' }}>
                                {{ $t }}
                            </option>
                        @endforeach
                    </select>

                    <button class="btn-sm" type="submit">Aplicar</button>

                    @if (request('tipo'))
                        <a class="btn-sm ghost" href="{{ route('productos.index') }}">Limpiar</a>
                    @endif
                </div>

                <div class="prod-count">
                    <span>Mostrando</span>
                    <strong>{{ $productos->count() }}</strong>
                    <span>de</span>
                    <strong>{{ $productos->total() }}</strong>
                </div>
            </form>

            {{-- Table --}}
            <div class="prod-card table-card">
                <div class="table-wrap">
                    <table class="table prod-table">
                        <thead>
                            <tr>
                                <th style="width:90px;">ID</th>
                                <th>Tipo</th>
                                <th style="width:160px;">Precio</th>
                                <th style="width:160px;">Estado</th>
                                <th style="width:220px; text-align:right;">Acciones</th>
                            </tr>
                        </thead>

                        <tbody>
                            @forelse($productos as $p)
                                <tr>
                                    <td class="prod-id">{{ $p->ID_PRODUCTO }}</td>

                                    <td>
                                        <span class="prod-chip">{{ $p->TIPO_PRODUCTO }}</span>
                                    </td>

                                    <td class="prod-price">
                                        S/ {{ number_format($p->PRECIO_PRODUCTO, 2) }}
                                    </td>

                                    <td>
                                        <span class="badge {{ $p->ESTADO_PRODUCTO === 'ACTIVO' ? 'ok' : 'warn' }}">
                                            {{ $p->ESTADO_PRODUCTO }}
                                        </span>
                                    </td>

                                    <td style="text-align:right;">
                                        <div class="prod-actions">
                                            <a class="act edit" href="{{ route('productos.edit', $p->ID_PRODUCTO) }}">
                                                ✏️ <span>Editar</span>
                                            </a>

                                            <form method="POST" action="{{ route('productos.destroy', $p->ID_PRODUCTO) }}"
                                                onsubmit="return confirm('¿Eliminar producto?')">
                                                @csrf
                                                @method('DELETE')
                                                <button class="act del" type="submit">
                                                    🗑️ <span>Eliminar</span>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="prod-emptyCell">
                                        <div class="prod-empty">
                                            <div class="prod-emptyIcon">📦</div>
                                            <div>
                                                <h3>No hay productos</h3>
                                                <p>Para este tipo no hay registros.</p>
                                                <a class="btn-sm primary" href="{{ route('productos.create') }}">＋ Nuevo
                                                    producto</a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="prod-footer">
                    {{ $productos->links() }}
                </div>
            </div>
        </div>

    </div>
@endsection
