@extends('layouts.app')
@section('title', 'Crear Usuario')

@push('styles')
    @vite(['resources/css/usuarios-form.css'])
@endpush

@section('content')
    <div class="form-page">
        <div class="form-card tul-card">

            <div class="form-head">
                <div>
                    <h1>Crear Usuario</h1>
                    <p class="muted">Registra un nuevo acceso al sistema.</p>
                </div>

                <div class="head-chip">
                    <span class="chip">USUARIOS</span>
                    <span class="chip soft">NUEVO</span>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert err">
                    Revisa los campos marcados.
                </div>
            @endif

            <form method="POST" action="{{ route('usuarios.store') }}">
                @csrf

                <div class="grid-2">
                    {{-- ID Usuario --}}
                    <div class="field">
                        <label>ID Usuario</label>
                        <input type="text" name="ID_USUARIO" value="{{ old('ID_USUARIO') }}"
                            placeholder="Ej: MARIA AVENDANO T." required>
                        @error('ID_USUARIO')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Empleado --}}
                    <div class="field">
                        <label>Empleado</label>
                        <select name="ID_EMPLEADO" required>
                            <option value="">Seleccionar...</option>
                            @foreach ($empleados as $e)
                                <option value="{{ $e->ID_EMPLEADO }}"
                                    {{ old('ID_EMPLEADO') == $e->ID_EMPLEADO ? 'selected' : '' }}>
                                    {{ $e->ID_EMPLEADO }} — {{ $e->NOMBRES }} {{ $e->APELLIDOS }}
                                </option>
                            @endforeach
                        </select>
                        @error('ID_EMPLEADO')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Contraseña --}}
                    <div class="field">
                        <label>Contraseña</label>
                        <input type="password" name="CONTRASENA" placeholder="Mínimo 6 caracteres" required>
                        @error('CONTRASENA')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Rol --}}
                    <div class="field">
                        <label>Rol</label>
                        <select name="ROL" required>
                            <option value="ADMIN" {{ old('ROL', 'ADMIN') === 'ADMIN' ? 'selected' : '' }}>ADMIN</option>
                            <option value="VENDEDOR" {{ old('ROL') === 'VENDEDOR' ? 'selected' : '' }}>VENDEDOR</option>
                        </select>
                        @error('ROL')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Estado --}}
                    <div class="field">
                        <label>Estado</label>
                        <select name="ESTADO_USUARIO" required>
                            <option value="ACTIVO" {{ old('ESTADO_USUARIO', 'ACTIVO') === 'ACTIVO' ? 'selected' : '' }}>
                                ACTIVO</option>
                            <option value="INACTIVO" {{ old('ESTADO_USUARIO') === 'INACTIVO' ? 'selected' : '' }}>INACTIVO
                            </option>
                        </select>
                        @error('ESTADO_USUARIO')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Ayuda visual --}}
                    <div class="field">
                        <label>Recomendación</label>
                        <div class="help">
                            Usa un ID claro y consistente. Ejemplo:<br>
                            <b>NOMBRE APELLIDO</b> o <b>EMP001</b> (según tu estándar).
                        </div>
                    </div>
                </div>

                <div class="actions">
                    <button class="btn primary" type="submit">Guardar</button>
                    <a class="btn ghost" href="{{ route('usuarios.index') }}">Volver</a>
                </div>
            </form>

        </div>
    </div>
@endsection
