@extends('layouts.app')
@section('title', 'Editar Usuario')

@push('styles')
    @vite(['resources/css/usuarios-form.css'])
@endpush

@section('content')
    @php
        // $usuario, $empleados deberían venir del controller
        // Ej: return view('usuarios.edit', compact('usuario','empleados'));
    @endphp

    <div class="form-page">
        <div class="form-card tul-card">
            <div class="form-head">
                <div>
                    <h1>Editar Usuario</h1>
                    <p class="muted">Usuario: <b>{{ $usuario->ID_USUARIO }}</b></p>
                </div>

                <div class="head-chip">
                    <span class="chip">{{ $usuario->ROL }}</span>
                    <span class="chip soft">{{ $usuario->ESTADO_USUARIO }}</span>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert err">
                    Revisa los campos marcados.
                </div>
            @endif

            <form method="POST" action="{{ route('usuarios.update', $usuario->ID_USUARIO) }}">
                @csrf
                @method('PUT')

                <div class="grid-2">
                    {{-- Empleado --}}
                    <div class="field">
                        <label>Empleado</label>
                        <select name="ID_EMPLEADO" required>
                            @foreach ($empleados as $e)
                                <option value="{{ $e->ID_EMPLEADO }}"
                                    {{ $usuario->ID_EMPLEADO == $e->ID_EMPLEADO ? 'selected' : '' }}>
                                    {{ $e->ID_EMPLEADO }} — {{ $e->NOMBRES }} {{ $e->APELLIDOS }}
                                </option>
                            @endforeach
                        </select>
                        @error('ID_EMPLEADO')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Contraseña --}}
                    <div class="field">
                        <label>Nueva contraseña <span class="hint">(opcional)</span></label>
                        <input type="password" name="CONTRASENA" placeholder="Dejar vacío para no cambiar">
                        <div class="help">Si no deseas cambiarla, déjalo vacío.</div>
                        @error('CONTRASENA')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Rol --}}
                    <div class="field">
                        <label>Rol</label>
                        <select name="ROL" required>
                            <option value="ADMIN" {{ $usuario->ROL === 'ADMIN' ? 'selected' : '' }}>ADMIN</option>
                            <option value="VENDEDOR" {{ $usuario->ROL === 'VENDEDOR' ? 'selected' : '' }}>VENDEDOR</option>
                        </select>
                        @error('ROL')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Estado --}}
                    <div class="field">
                        <label>Estado</label>
                        <select name="ESTADO_USUARIO" required>
                            <option value="ACTIVO" {{ $usuario->ESTADO_USUARIO === 'ACTIVO' ? 'selected' : '' }}>ACTIVO
                            </option>
                            <option value="INACTIVO" {{ $usuario->ESTADO_USUARIO === 'INACTIVO' ? 'selected' : '' }}>
                                INACTIVO</option>
                        </select>
                        @error('ESTADO_USUARIO')
                            <div class="err-text">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="actions">
                    <button class="btn primary" type="submit">Actualizar</button>
                    <a class="btn ghost" href="{{ route('usuarios.index') }}">Volver</a>
                </div>
            </form>
        </div>
    </div>
@endsection
