@extends('layouts.app')
@section('title', 'Usuarios')

@push('styles')
    @vite(['resources/css/usuarios.css'])
@endpush

@section('content')
    <div class="page">
        <div class="card-shell">
            <div class="head">
                <div>
                    <h1 class="title">Usuarios</h1>
                    <p class="sub">Gestiona cuentas, roles y estado del sistema Tulinda.</p>
                </div>

                <div class="head-actions">
                    <a class="btn primary" href="{{ route('usuarios.create') }}">+ Nuevo usuario</a>
                </div>
            </div>

            {{-- Alertas --}}
            @if (session('ok'))
                <div class="alert ok">{{ session('ok') }}</div>
            @endif
            @if (session('error'))
                <div class="alert err">{{ session('error') }}</div>
            @endif

            {{-- Toolbar --}}
            <div class="toolbar">
                <div class="search">
                    <span class="ico">🔎</span>
                    <input id="userSearch" type="text" placeholder="Buscar por usuario, empleado o rol...">
                </div>

                <div class="meta">
                    <span class="pill">{{ $usuarios->total() ?? count($usuarios) }} registros</span>
                </div>
            </div>

            {{-- Tabla --}}
            <div class="table-wrap">
                <table class="tul-table" id="userTable">
                    <thead>
                        <tr>
                            <th>ID USUARIO</th>
                            <th>ID EMPLEADO</th>
                            <th>ROL</th>
                            <th>ESTADO</th>
                            <th style="text-align:right;">ACCIONES</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($usuarios as $u)
                            @php
                                $rol = $u->ROL ?? '';
                                $estado = $u->ESTADO_USUARIO ?? '';
                                $rolClass = $rol === 'ADMIN' ? 'role admin' : 'role vendor';
                                $stClass = $estado === 'ACTIVO' ? 'status on' : 'status off';
                            @endphp
                            <tr>
                                <td class="strong">{{ $u->ID_USUARIO }}</td>
                                <td>{{ $u->ID_EMPLEADO }}</td>
                                <td><span class="{{ $rolClass }}">{{ $rol }}</span></td>
                                <td><span class="{{ $stClass }}">{{ $estado }}</span></td>
                                <td class="actions">
                                    <a class="btn-sm" href="{{ route('usuarios.edit', $u->ID_USUARIO) }}">Editar</a>

                                    <form method="POST" action="{{ route('usuarios.destroy', $u->ID_USUARIO) }}"
                                        onsubmit="return confirm('¿Eliminar usuario {{ $u->ID_USUARIO }}?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn-sm danger" type="submit">Eliminar</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="empty">No hay usuarios registrados.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Paginación --}}
            @if (method_exists($usuarios, 'links'))
                <div class="pager">
                    {{ $usuarios->links() }}
                </div>
            @endif
        </div>
    </div>

    <script>
        // filtro local por texto (sin recargar)
        const input = document.getElementById('userSearch');
        const rows = Array.from(document.querySelectorAll('#userTable tbody tr'));

        input?.addEventListener('input', () => {
            const q = input.value.toLowerCase().trim();
            rows.forEach(r => {
                const txt = r.innerText.toLowerCase();
                r.style.display = txt.includes(q) ? '' : 'none';
            });
        });
    </script>
@endsection
