@extends('layouts.app')
@section('title', 'Ventas')

@push('styles')
    @vite(['resources/css/ventas.css'])
@endpush

@section('content')
    @php
        $rol = session('usuario.ROL');
    @endphp

    <div class="v-page">

        {{-- ALERTAS --}}
        @if (session('error'))
            <div class="v-alert danger">
                <span class="ico">⚠️</span>
                <div class="txt">{{ session('error') }}</div>
            </div>
        @endif

        @if (session('ok'))
            <div class="v-alert ok">
                <span class="ico">✅</span>
                <div class="txt">{{ session('ok') }}</div>
            </div>
        @endif

        <div class="v-head">
            <div>
                <h1>Ventas</h1>
                <p class="sub">Registra y revisa las ventas del día. (Todos los turnos ven lo mismo)</p>
            </div>

            {{-- ✅ BOTÓN BLOQUEADO SI YA HAY REPORTE O CIERRE HOY --}}
            @if (!empty($diaBloqueado) && $diaBloqueado)
                <span class="btn-primary btn-new is-disabled" title="Día cerrado: ventas habilitadas mañana">
                    <span class="plus">🔒</span>
                    <span class="txt">Día cerrado</span>
                </span>
            @else
                <a class="btn-primary btn-new" href="{{ route('ventas.create') }}">
                    <span class="plus">+</span>
                    <span class="txt">Nueva venta</span>
                </a>
            @endif
        </div>

        {{-- Resumen del día --}}
        <div class="v-stats">
            <div class="stat stat-total">
                <div class="s-top">
                    <div class="k">Total (hoy)</div>
                    <div class="s-ico">📌</div>
                </div>
                <div class="v">S/ {{ number_format($totales['total'] ?? 0, 2) }}</div>
                <div class="t">Suma final de ventas</div>
            </div>

            <div class="stat stat-ef">
                <div class="s-top">
                    <div class="k">Efectivo</div>
                    <div class="s-ico">💵</div>
                </div>
                <div class="v">S/ {{ number_format($totales['efectivo'] ?? 0, 2) }}</div>
                <div class="t">Cobros en efectivo</div>
            </div>

            <div class="stat stat-yape">
                <div class="s-top">
                    <div class="k">Yape/Plin</div>
                    <div class="s-ico">📲</div>
                </div>
                <div class="v">S/ {{ number_format($totales['yape'] ?? 0, 2) }}</div>
                <div class="t">Pagos móviles</div>
            </div>

            <div class="stat stat-tar">
                <div class="s-top">
                    <div class="k">Tarjeta</div>
                    <div class="s-ico">💳</div>
                </div>
                <div class="v">S/ {{ number_format($totales['tarjeta'] ?? 0, 2) }}</div>
                <div class="t">Cobros POS</div>
            </div>
        </div>

        {{-- Tabla --}}
        <div class="table-card">
            <div class="table-head">
                <h2>Listado</h2>
                <span class="badge">{{ $ventas->total() }} registros</span>
            </div>

            <div class="table-wrap">
                <table class="tul-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Fecha</th>
                            <th>Producto</th>
                            <th>Cant.</th>
                            <th>Pago</th>
                            <th>Subtotal</th>
                            <th>Desc.</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($ventas as $v)
                            <tr>
                                <td>#{{ $v->ID_VENTA }}</td>
                                <td>{{ \Carbon\Carbon::parse($v->FECHA_REGISTRO)->format('d/m/Y H:i') }}</td>
                                <td><b>{{ $v->ID_PRODUCTO }}</b></td>
                                <td>{{ $v->CANTIDAD }}</td>

                                <td>
                                    <span class="pill {{ strtolower($v->METODO_PAGO) }}">
                                        {{ str_replace('_', '/', $v->METODO_PAGO) }}
                                    </span>
                                </td>

                                <td>S/ {{ number_format($v->MONTO_PRODUCTO, 2) }}</td>
                                <td>S/ {{ number_format($v->DESCUENTO_PRODUCTO, 2) }}</td>
                                <td><b>S/ {{ number_format($v->TOTAL_VENTA, 2) }}</b></td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="empty">No hay ventas registradas.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="pager">
                {{ $ventas->links() }}
            </div>
        </div>
    </div>
@endsection
