<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\EmpleadoController;
use App\Http\Controllers\ProductoController;
use App\Http\Controllers\UsuarioController;

use App\Http\Controllers\LoginController;
use App\Http\Controllers\DashboardController;

use App\Http\Controllers\AperturaCajaController;
use App\Http\Controllers\VentaController;
use App\Http\Controllers\ReporteVentaController;
use App\Http\Controllers\CierreCajaController;


Route::get('/', fn() => redirect()->route('login.form'));

// Login
Route::get('/login', [LoginController::class, 'form'])->name('login.form');
Route::post('/login', [LoginController::class, 'login'])->name('login.do');
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Todo protegido
Route::middleware('auth.simple')->group(function () {

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // ===== CAJA =====
    // Apertura
    Route::get('/apertura', [AperturaCajaController::class, 'index'])->name('apertura.index');
    Route::get('/apertura/create', [AperturaCajaController::class, 'create'])->name('apertura.create');
    Route::post('/apertura', [AperturaCajaController::class, 'store'])->name('apertura.store');

    // Ventas
    Route::get('/ventas', [VentaController::class, 'index'])->name('ventas.index');
    Route::get('/ventas/create', [VentaController::class, 'create'])->name('ventas.create');
    Route::post('/ventas', [VentaController::class, 'store'])->name('ventas.store');

    // Reporte (solo ADMIN lo controla el controller)
    Route::get('/reporte', [ReporteVentaController::class, 'index'])->name('reporte.index');
    Route::post('/reporte/generar-hoy', [ReporteVentaController::class, 'generarHoy'])->name('reporte.hoy');
    Route::post('/reporte/hoy', [ReporteVentaController::class, 'generarHoy'])->name('reporte.hoy');

    // Cierre
    Route::get('/cierre', [CierreCajaController::class, 'index'])->name('cierre.index');
    Route::get('/cierre/create', [CierreCajaController::class, 'create'])->name('cierre.create');
    Route::post('/cierre', [CierreCajaController::class, 'store'])->name('cierre.store');

    // ===== CRUDS =====
    Route::resource('empleados', EmpleadoController::class);
    Route::resource('productos', ProductoController::class);
    Route::resource('usuarios', UsuarioController::class);
});

Route::middleware(['bloq_ventas_dia'])->group(function () {
    Route::get('/ventas/create', [VentaController::class, 'create'])->name('ventas.create');
    Route::post('/ventas', [VentaController::class, 'store'])->name('ventas.store');
});


Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
Route::get('/dashboard/data', [DashboardController::class, 'data'])->name('dashboard.data');
